# New Tab Notepad Chrome Extension

A professional markdown editor that replaces your new tab page with a distraction-free notepad. Features auto-save, markdown export, and persistent storage with real-time sync across tabs. **Powered by TOAST UI Editor for the best markdown editing experience!**

## Features

- **TOAST UI Editor**: Professional markdown editor with live preview
- **WYSIWYG Mode**: Switch between markdown and WYSIWYG editing
- **Live Preview**: See your markdown rendered in real-time with scroll sync
- **Auto-Save**: Automatically saves your notes as you type
- **Real-Time Sync**: Changes appear instantly across all tabs
- **Persistent Storage**: Uses Chrome's storage API for reliable data persistence
- **Markdown Export**: Export your notes as a markdown file
- **Rich Toolbar**: Complete formatting toolbar with all markdown features
- **Dark/Light Theme**: Built-in theme support
- **Keyboard Shortcuts**: Full keyboard support for formatting
- **Smart Lists**: Press Enter in lists to continue lists automatically
- **Table Support**: Full table editing with context menus
- **Task Lists**: Interactive checkboxes with `- [ ]` and `- [x]`
- **Code Blocks**: Syntax highlighting for multiple languages
- **Image Support**: Drag and drop image insertion
- **Link Management**: Easy link insertion and editing

## Installation

### Method 1: Load Unpacked Extension (Development)

1. Clone or download this repository
2. Open Chrome and go to `chrome://extensions/`
3. Enable "Developer mode" in the top right
4. Click "Load unpacked" and select the extension folder
5. Open a new tab to see the editor

### Method 2: Install from Chrome Web Store (Coming Soon)

The extension will be available on the Chrome Web Store soon.

## Usage

### Basic Editing
- Start typing immediately - your notes auto-save
- Use the toolbar buttons for formatting
- Keyboard shortcuts work as expected

### Keyboard Shortcuts
- `Ctrl/Cmd + B`: Bold
- `Ctrl/Cmd + I`: Italic
- `Ctrl/Cmd + U`: Underline
- `Ctrl/Cmd + S`: Manual save
- `Tab`: Indent list items
- `Shift + Tab`: Outdent list items
- `Enter`: New line (or exit lists)

### Markdown Syntax Support
Write standard markdown syntax and see it rendered in real-time:
- `# Heading` → H1 heading
- `## Heading` → H2 heading  
- `### Heading` → H3 heading
- `- Item` → Bullet list
- `1. Item` → Numbered list
- `- [ ] Task` → Unchecked checkbox
- `- [x] Task` → Checked checkbox
- `> Quote` → Blockquote
- `` `code` `` → Inline code
- ```` ```language` → Code block
- `[Link](url)` → Links
- `**bold**` → Bold text
- `*italic*` → Italic text

### Toolbar Features
- **Preview Toggle**: Switch between edit and preview modes
- **Text Formatting**: Bold (`**text**`), italic (`*text*`), code (`` `code` ``)
- **Headings**: H1 (`#`), H2 (`##`), H3 (`###`) levels
- **Lists**: Bullet points (`-`), numbered lists (`1.`)
- **Checkboxes**: Interactive checkboxes (`- [ ]`)
- **Code Blocks**: Multi-line code blocks (```` ``` ````)
- **Quotes**: Blockquotes (`>`)
- **Links**: Insert URLs with `[text](url)`
- **Export**: Download as markdown file
- **Theme**: Toggle dark/light mode

### Export
Click the "Export" button to download your notes as a markdown file. The file will be named with the current date.

## Data Persistence

The extension uses Chrome's `storage.local` API, which provides:

- **Automatic syncing** across devices (when signed into Chrome)
- **Persistent storage** that survives browser restarts
- **Reliable backup** - data is stored locally and in Chrome's cloud

### When Data Might Be Lost
- User manually clears browser data
- Browser uninstall/reinstall
- Incognito mode (cleared when window closes)
- Storage quota exceeded (very rare)
- Browser crashes/corruption (rare)

## Technical Details

- **Manifest Version**: 3 (latest Chrome extension standard)
- **Storage**: Chrome storage.local API
- **Editor**: ContentEditable with custom formatting
- **Export**: HTML to Markdown conversion
- **Themes**: CSS-based dark/light mode

## Development

### File Structure
```
├── manifest.json      # Extension configuration
├── newtab.html       # New tab page HTML
├── styles.css        # Styling and themes
├── editor.js         # Main editor functionality
├── icons/            # Extension icons
└── README.md         # This file
```

### Local Development
1. Make changes to the code
2. Go to `chrome://extensions/`
3. Click the refresh icon on your extension
4. Open a new tab to test changes

## Contributing

Feel free to submit issues and pull requests!

## License

MIT License - feel free to use and modify as needed.

## Similar Extensions

This extension was inspired by popular new tab note-taking extensions like:
- [New Tab Notepad](https://github.com/kylekampy/NewTabNotes)
- [MarkdownTab](https://github.com/dbernheisel/MarkdownTab)

## Support

If you encounter any issues:
1. Check the browser console for errors
2. Try refreshing the extension
3. Clear and reload the extension
4. Open an issue on GitHub 